using System;
using System.Collections.Generic;
using System.Text;

namespace IlijaDoncic
{
    class IlijaDoncic
    {
        static void Main()
        {
            string[] input = Console.ReadLine().Split();
            int N = int.Parse(input[0]);
            int K = int.Parse(input[1]);

            input = Console.ReadLine().Split();
            HashSet<int> storeLocations = new HashSet<int>();
            for (int i = 0; i < K; i++)
            {
                int location = int.Parse(input[i]);
                storeLocations.Add(location);
            }

            input = Console.ReadLine().Split();
            long[] population = new long[N];
            for (int i = 0; i < N; i++)
            {
                population[i] = long.Parse(input[i]);
            }

            long totalPopulation = 0;
            foreach (long pop in population)
            {
                totalPopulation += pop;
            }

            long halfPopulation = (totalPopulation + 1) / 2;

            long minStores = long.MaxValue;
            long currentPopulation = 0;
            foreach (int location in storeLocations)
            {
                currentPopulation += population[location - 1];
                if (currentPopulation >= halfPopulation)
                {
                    minStores = 1;
                    break;
                }
            }

            if (minStores != 1)
            {
                long remainingPopulation = halfPopulation - currentPopulation;
                List<long> remainingCitiesPopulation = new List<long>();
                for (int i = 0; i < N; i++)
                {
                    if (!storeLocations.Contains(i + 1))
                    {
                        remainingCitiesPopulation.Add(population[i]);
                    }
                }
                remainingCitiesPopulation.Sort();

                int storesNeeded = 0;
                for (int i = remainingCitiesPopulation.Count - 1; i >= 0; i--)
                {
                    remainingPopulation -= remainingCitiesPopulation[i];
                    storesNeeded++;
                    if (remainingPopulation <= 0)
                    {
                        minStores = Math.Min(minStores, storesNeeded);
                        break;
                    }
                }
            }

            if (minStores == long.MaxValue)
            {
                Console.WriteLine("-1");
            }
            else
            {
                Console.WriteLine(minStores);
            }
        }
    }

}